unit Unit2;
                       
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls,CU30DLL, ComCtrls, Spin, Grids, Mask,
  Menus;

type
    TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    Button1: TButton;
    Button2: TButton;
    SpinEdit2: TSpinEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    SpinEdit3: TSpinEdit;
    Button3: TButton;
    Button4: TButton;
    SpinEdit4: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    SpinEdit5: TSpinEdit;
    Button5: TButton;
    Button6: TButton;
    SpinEdit6: TSpinEdit;
    StatusBar1: TStatusBar;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;


    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure FormCreate(Sender: TObject);
    
    procedure SpinEdit1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure Label3MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label3MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label6MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label6MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label6MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label9MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label9MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label9MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Label3MouseLeave(Sender: TObject);
    procedure Label6MouseLeave(Sender: TObject);
    procedure Label9MouseLeave(Sender: TObject);


  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;


var
  Form1: TForm1;
  Speed: byte;
  USB01: DeviceRec;
  bin3: array[0..8191] of byte;
  br: ByteRec64;
  TVel:integer;
  TPos:longint;
  Axis,PAxis:byte;
  StepVel:word;
  StepNumber:integer;
  vel,pvel,univel,counter: integer;
  vx,vy,vz{,vel1,vel2,vel3,dv1,dv2,dv3,CU80Voltage}: integer;
  XSelected,YSelected,ZSelected: boolean;
  procedure GetFileVersionInfoDelphi();

implementation

{$R *.DFM}



procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   CU30DCDCOff(USB01);
   CU30Close(USB01);
   beep;
end;



{$R+}


procedure TForm1.FormCreate(Sender: TObject);
var lw: longword;
    b,EEPromID:byte;
    s,sexe,ss,sh,sl: string;
    sc: PChar256;
    EP: USBEEProm;
    i,error: integer;
    MaxIndex:word;
    BinBuffer: ByteRec8192;
    inf: inforec;
begin
   sexe:=ExtractFileName(Application.ExeName);
   Delete(sexe,length(sexe)-3,4);
   b:=Pos('-',sexe);
   b:=length(sexe)-b;
   case b of
   1: begin
         sl:=copy(sexe,length(sexe),1);
         if (sl[1] in ['0'..'9']) then
         begin
            val(sl,EEPromID,error);
            if Error<>0 then EEPromID:=0;
         end
         else EEPromID:=0;
      end;
   2: begin
         sl:=copy(sexe,length(sexe)-1,2);
         if (sl[1]='1') and (sl[2] in ['0'..'5']) then
         begin
            val(sl,EEPromID,error);
            if Error<>0 then EEPromID:=0;
         end
         else EEPromID:=0;
      end;
   else
      EEPromID:=0;
   end;

   Form1.Caption:='CU30-'+inttostr(EEPromID);

   USB01.USBInstance:=0;
   USB01.USBVersion:=1;
   USB01.DevID:=1;
   USB01.EEID:=EEPromID;

   sc:=CU30Open(USB01);
   s:=string(sc);
   if s<>'' then
   begin
      if Application.MessageBox(PChar(s),'USB Error',MB_OK) = IDOK then halt;
   end;
   TVel:=0;
   TPos:=0;

   EP:=GetUSBEEPromInfo(USB01);
   {memo1.Lines.Insert(0,' '+EP.ProductStr);
   memo1.Lines.Insert(1,' DeviceID: '+inttostr(EP.DeviceID));
   memo1.Lines.Insert(2,' EEPromID: '+inttostr(EP.EEPromID));
   memo1.Lines.Insert(3,' SerialNumber: '+inttostr(EP.SerialNumber));
   memo1.Lines.Insert(4,' Date: '+EP.Date); }
   pvel:=0;
   univel:=0;
   Label11.Caption:='EEPromID: '+inttostr(EP.EEPromID);

   CU30DCDCon(USB01);
   vx:=0;vy:=0;vz:=0;

   XSelected:=false;
   YSelected:=false;
   ZSelected:=false;
      GetFileVersionInfoDelphi();
end;


procedure TForm1.SpinEdit1Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit1.Text,l,i);
  if i<>0 then
    Spinedit1.text:=''
  else
  begin
     if l<Spinedit1.MinValue then l:=Spinedit1.MinValue;
     if l>Spinedit1.MaxValue then l:=Spinedit1.MaxValue;
     Spinedit1.Value:=l;
  end;
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
   CU30Step(USB01,1,SpinEdit1.Value,SpinEdit2.Value);
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit2.Text,l,i);
  if i<>0 then
    Spinedit2.text:=''
  else
  begin
     if l<Spinedit2.MinValue then l:=Spinedit2.MinValue;
     if l>Spinedit2.MaxValue then l:=Spinedit2.MaxValue;
     Spinedit2.Value:=l;
  end;
end;

procedure TForm1.Label3MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var i:integer;
    d:double;
begin
   d:=2000.0*((x*1.0)/(Label3.width-1.0)-0.5);
   i:=round(d);
   if i>1000 then i:=1000;
   if i<-1000 then i:=-1000;
   vx:=i;
   Statusbar1.Panels[0].text:='Vx='+inttostr(vx);
   if XSelected then CU30Move(usb01,1,vx,255);
end;

procedure TForm1.Label3MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   CU30PiezoStop(usb01);
   XSelected:=false;
   vx:=0;
   Statusbar1.Panels[0].text:='Vx='+inttostr(vx);
end;

procedure TForm1.Label3MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   XSelected:=true;
   CU30Move(usb01,1,vx,255);
end;

procedure TForm1.Label6MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   YSelected:=true;
   CU30Move(usb01,2,vy,255);
end;

procedure TForm1.Label6MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var i:integer;
    d:double;
begin
   d:=2000.0*((x*1.0)/(Label6.width-1.0)-0.5);
   i:=round(d);
   if i>1000 then i:=1000;
   if i<-1000 then i:=-1000;
   vy:=i;
   Statusbar1.Panels[1].text:='Vy='+inttostr(vy);
   if YSelected then CU30Move(usb01,2,vy,255);
end;

procedure TForm1.Label6MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   CU30PiezoStop(usb01);
   YSelected:=false;
   vy:=0;
   Statusbar1.Panels[1].text:='Vy='+inttostr(vy);
end;

procedure TForm1.Label9MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   ZSelected:=true;
   CU30Move(usb01,3,vz,255);
end;

procedure TForm1.Label9MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var i:integer;
    d:double;
begin
   d:=2000.0*((x*1.0)/(Label9.width-1.0)-0.5);
   i:=round(d);
   if i>1000 then i:=1000;
   if i<-1000 then i:=-1000;
   vz:=i;
   Statusbar1.Panels[2].text:='Vz='+inttostr(vz);
   if ZSelected then CU30Move(usb01,3,vz,255);
end;

procedure TForm1.Label9MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   CU30PiezoStop(usb01);
   ZSelected:=false;
   vz:=0;
   Statusbar1.Panels[2].text:='Vz='+inttostr(vz);
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit3.Text,l,i);
  if i<>0 then
    Spinedit3.text:=''
  else
  begin
     if l<Spinedit3.MinValue then l:=Spinedit3.MinValue;
     if l>Spinedit3.MaxValue then l:=Spinedit3.MaxValue;
     Spinedit3.Value:=l;
  end;
end;

procedure TForm1.SpinEdit5Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit5.Text,l,i);
  if i<>0 then
    Spinedit5.text:=''
  else
  begin
     if l<Spinedit5.MinValue then l:=Spinedit5.MinValue;
     if l>Spinedit5.MaxValue then l:=Spinedit5.MaxValue;
     Spinedit5.Value:=l;
  end;
end;

procedure TForm1.SpinEdit4Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit4.Text,l,i);
  if i<>0 then
    Spinedit4.text:=''
  else
  begin
     if l<Spinedit4.MinValue then l:=Spinedit4.MinValue;
     if l>Spinedit4.MaxValue then l:=Spinedit4.MaxValue;
     Spinedit4.Value:=l;
  end;
end;

procedure TForm1.SpinEdit6Change(Sender: TObject);
var l:longint;
    i:integer;
begin
   Val(SpinEdit6.Text,l,i);
  if i<>0 then
    Spinedit6.text:=''
  else
  begin
     if l<Spinedit6.MinValue then l:=Spinedit6.MinValue;
     if l>Spinedit6.MaxValue then l:=Spinedit6.MaxValue;
     Spinedit6.Value:=l;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   CU30Step(USB01,1,-SpinEdit1.Value,SpinEdit2.Value);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   CU30Step(USB01,2,-SpinEdit3.Value,SpinEdit4.Value);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
   CU30Step(USB01,3,-SpinEdit5.Value,SpinEdit6.Value);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   CU30Step(USB01,2,SpinEdit3.Value,SpinEdit4.Value);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
   CU30Step(USB01,3,SpinEdit5.Value,SpinEdit6.Value);
end;

procedure TForm1.Label3MouseLeave(Sender: TObject);
begin
   vx:=0;
   Statusbar1.Panels[0].text:='Vx='+inttostr(vx);
end;

procedure TForm1.Label6MouseLeave(Sender: TObject);
begin
   vy:=0;
   Statusbar1.Panels[1].text:='Vy='+inttostr(vy);
end;

procedure TForm1.Label9MouseLeave(Sender: TObject);
begin
   vz:=0;
   Statusbar1.Panels[2].text:='Vz='+inttostr(vz);
end;

procedure GetFileVersionInfoDelphi;
const
  infoString: String ='StringFileInfo\040904E4\FileVersion';
var
  S: string;
  n,Len: DWORD;
  Buf: PChar;
  Value: PChar;
  VersionValue,aFileVersion: AnsiString;
  bfind: LongBool;
begin
  S := Application.ExeName;
   n := GetFileVersionInfoSize(PChar(S), n);
   if n > 0 then
   begin
     Buf := AllocMem(n);
     GetFileVersionInfo(PChar(S), 0, n, Buf);
     if VerQueryValue(Buf, '\VarFileInfo\Translation', Pointer(Value), Len) then
     begin
       VersionValue := '\StringFileInfo\' +
                      IntToHex(LoWord(LongInt(Pointer(Value)^)), 4) +
                      IntToHex(HiWord(LongInt(Pointer(Value)^)), 4) + '\';
       Len:=0;
       bfind:=VerQueryValue(
       Buf, PChar(VersionValue + 'FileVersion'), Pointer(Value), Len );
       aFileVersion := AnsiString(Value);
       aFileVersion := Trim(aFileVersion);
       Form1.StatusBar1.Panels[3].Text:='File version:   ' + aFileVersion;
     end ;
     FreeMem(Buf, n);
   end
end;
end.


